<?php
require_once __DIR__.'/maincore.php';
require_once THEMES.'templates/header.php';
add_to_title('Rezerwacja sprzętu online');
set_meta("description","wypożycz sprzęt lokalnie z plaży i pływaj na godziny tyle, ile chcesz. Do dyspozycji mamy: kajaki, deski SUP, motorówki.");add_to_footer("
<script>
    const kayakPrices = {
        expedition: 80,
        '2+1': 70,
        kanoe: 50,
        sprinter: 50,
        vista: 60,
        jedynka: 40,
        smart: 40,
        '3_person': 50
    };
    function calculateCost() {
        const kayakType = document.getElementById('kayak_type').value;
        const quantity = parseInt(document.getElementById('quantity').value);
        const days = parseInt(document.getElementById('days').value);
        const cost = kayakPrices[kayakType] * days * quantity;
        document.getElementById('total_cost').value = cost + ' zł';
    }
    document.addEventListener('DOMContentLoaded', calculateCost);
</script> ");
?>
<div class="container">
    <h1 class="text-center">Formularz Rezerwacji Kajaków</h1>
    <form id="reservationForm" action="rezerwacja/rezerwacja.php" method="POST" class="form-horizontal">
        <div class="form-group">
            <label for="email" class="col-sm-2 control-label">Adres e-mail:</label>
            <div class="col-sm-10">
                <input type="email" id="email" name="email" class="form-control" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="name" class="col-sm-2 control-label">Nazwisko/Imię:</label>
            <div class="col-sm-10">
                <input type="text" id="name" name="name" class="form-control" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="phone" class="col-sm-2 control-label">Numer telefonu:</label>
            <div class="col-sm-10">
                <input type="text" id="phone" name="phone" class="form-control" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="street" class="col-sm-2 control-label">Ulica:</label>
            <div class="col-sm-10">
                <input type="text" id="street" name="street" class="form-control" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="house_number" class="col-sm-2 control-label">Numer domu:</label>
            <div class="col-sm-10">
                <input type="text" id="house_number" name="house_number" class="form-control" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="city" class="col-sm-2 control-label">Miejscowość:</label>
            <div class="col-sm-10">
                <input type="text" id="city" name="city" class="form-control" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="kayak_type" class="col-sm-2 control-label">Wybierz typ kajaka:</label>
            <div class="col-sm-10">
                <select id="kayak_type" name="kayak_type" class="form-control" onchange="calculateCost()" required>
                    <option value="expedition">Kajak Expedition - 80 zł za dzień</option>
                    <option value="2+1">Kajak 2+1 - 70 zł za dzień</option>
                    <option value="kanoe">Kanoe - 50 zł za dzień</option>
                    <option value="sprinter">Sprinter (polietylenowe) - 50 zł za dzień</option>
                    <option value="vista">Vista (polietylenowe) - 60 zł za dzień</option>
                    <option value="jedynka">Jedynka - 40 zł za dzień</option>
                    <option value="smart">Jedynka Smart/Traper - 40 zł za dzień</option>
                    <option value="3_person">Kajak 3 osobowy - 50 zł za dzień</option>
                </select>
            </div>
        </div>
        
        <div class="form-group">
            <label for="quantity" class="col-sm-2 control-label">Ilość kajaków:</label>
            <div class="col-sm-10">
                <input type="number" id="quantity" name="quantity" class="form-control" min="1" max="10" value="1" onchange="calculateCost()" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="days" class="col-sm-2 control-label">Ilość dni:</label>
            <div class="col-sm-10">
                <input type="number" id="days" name="days" class="form-control" min="1" value="1" onchange="calculateCost()" required>
            </div>
        </div>
        
        <div class="form-group">
            <label for="total_cost" class="col-sm-2 control-label">Całkowity koszt:</label>
            <div class="col-sm-10">
                <input type="text" id="total_cost" name="total_cost" class="form-control" readonly>
            </div>
        </div>
        
        <div class="form-group">
            <div class="col-sm-offset-2 col-sm-10">
                <button type="submit" class="btn btn-primary">Zarezerwuj</button>
            </div>
        </div>
    </form>
</div></div>
<?php require_once THEMES.'templates/footer.php';?>