<?php
/*
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 *
 * Author: Zbigniew
 * Website: https://nw.ct8.pl/artykul/67/wtyczka-weekly-panel-dla-cms-php-fusion
 *
 * If you redistribute this program, please include this information
 * about the author and the website.
 *
 * Please do not remove this license.
 */
require_once "../../../maincore.php";
require_once THEMES."templates/admin_header.php";

if (file_exists(INFUSIONS."weekly_panel/locale/".LANGUAGE.".php")) {
    include INFUSIONS."weekly_panel/locale/".LANGUAGE.".php";
} else {
    include INFUSIONS."weekly_panel/locale/English.php";
}

// Sprawdzenie uprawnień administratora
$aidlink = fusion_get_aidlink();
if (!checkrights("WKM") || !defined("iAUTH") || $_GET['aid'] != iAUTH) { 
    redirect("../../../index.php"); 
}
include INFUSIONS."weekly_panel/infusion_db.php";

// Inicjalizacja zmiennej dla wybranego pliku
$selected_file = '';

// Pobieranie treści wiadomości na poniedziałek
$result = dbquery("SELECT message_content FROM ".DB_WEEKLY_MESSAGES." WHERE day_of_week = '8'");
$data = dbarray($result);
if ($data) {
    $selected_file = $data['message_content']; // Ustawienie na ostatnio zapisany plik
}

// Odczytanie plików z folderu 'plus', z wykluczeniem index.php
$directory = '../plus/'; // Użyj '../' aby przejść do katalogu nadrzędnego
$options = [];

// Odczytanie plików z folderu
foreach (glob($directory . '*.php') as $file) {
    $filename = basename($file);
    if ($filename !== 'index.php') { // Wykluczenie index.php
        $options[] = $filename; // Dodaj tylko nazwę pliku
    }
}

// Sprawdzenie, czy wybrany plik jest poprawny przed zapisaniem
if (isset($_POST['save'])) {
    if (!empty($_POST['file_name'])) {
        $selected_file = addslashes($_POST['file_name']);
        
        // Walidacja, aby upewnić się, że nie jest to index.php
        if ($selected_file !== 'index.php') {
            dbquery("UPDATE ".DB_WEEKLY_MESSAGES." SET message_content='$selected_file' WHERE day_of_week='8'");
            // Można dodać komunikat potwierdzający zapisanie zmian
            addNotice('success', $locale['sawe_admin_success']);
        } else {
            // Możesz dodać komunikat o błędzie, jeśli wybrano index.php
            addNotice('error', 'Nie można wybrać pliku index.php.');
        }
    }
    redirect(FUSION_SELF.$aidlink);
}
echo '<div class="clearfix m-b-10">';
echo "<div style='text-align:center'><h3><strong>".$locale['menu_title']."</strong></h3></div><br>\n";
echo "<div class='row'>\n";
echo "<div class='col-md-12'>\n";
echo "<div align='center'><ul class='list-inline'>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/admin.php".$aidlink."'><strong>".$locale['menu_admin']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/poniedzialek.php".$aidlink."'><strong>".$locale['day_monday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/wtorek.php".$aidlink."'><strong>".$locale['day_tuesday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/sroda.php".$aidlink."'><strong>".$locale['day_wednesday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/czwartek.php".$aidlink."'><strong>".$locale['day_thursday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/piatek.php".$aidlink."'><strong>".$locale['day_friday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/sobota.php".$aidlink."'><strong>".$locale['day_saturday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/niedziela.php".$aidlink."'><strong>".$locale['day_sunday']."</strong></a></li>\n";
echo "<li><a class='btn btn-success btn-md' href='".INFUSIONS."weekly_panel/admin/niezalogowany.php".$aidlink."'><strong>".$locale['Log_nie']."</strong></a></li>\n";
echo "<li><a class='btn btn-success btn-md' href='".INFUSIONS."weekly_panel/admin/zalogowany.php".$aidlink."'><strong>".$locale['Log_tak']."</strong></a></li>\n"; 
echo "<li><a class='btn btn-success btn-md' href='".INFUSIONS."weekly_panel/admin/godziny.php".$aidlink."'><strong>".$locale['Log_hurs']."</strong></a></li>\n";
echo "</ul></div></div></div><br>\n";
echo "<div align='center'><h3><strong>".$locale['edit_plik']."</strong></h3></div>\n";
// Formularz do edycji 
echo '<form method="post" action="'.FUSION_SELF.$aidlink.'">';
echo '<label>Wybierz plik:</label>';
echo '<select name="file_name">';
foreach ($options as $option) {
    echo '<option value="'.$option.'" '.($selected_file == $option ? 'selected' : '').'>'.$option.'</option>';
}
echo '</select>';
echo "<div class='text-center'>
<button type='submit' name='save' class='btn btn-primary btn-md'>".$locale['sawe_admin']."</button>
</div></form>";
echo "<div align='center'><h3><strong>".$locale['edit_info']."</strong></h3></div>\n";

include INFUSIONS."weekly_panel/admin/info.php";
require_once THEMES."templates/footer.php";
?>
