<?php

require_once "../../../maincore.php";
require_once THEMES."templates/admin_header.php";
add_to_head('<script src="../../../includes/jscripts/tinymce5/tinymce.min.js"></script>');
add_to_head('<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">');

if (file_exists(INFUSIONS."weekly_panel/locale/".LANGUAGE.".php")) {
    include INFUSIONS."weekly_panel/locale/".LANGUAGE.".php";
} else {
    include INFUSIONS."weekly_panel/locale/English.php";
}

$aidlink = fusion_get_aidlink();
if (!checkrights("WKM") || !defined("iAUTH") || $_GET['aid'] != iAUTH) { 
    redirect("../../../index.php");
} 

include INFUSIONS . "weekly_panel/infusion_db.php";

// Sprawdzenie, czy formularz został wysłany
if (isset($_POST['save'])) {
    if (isset($_POST['day_of_week']) && isset($_POST['message_content']) && !empty($_POST['message_content'])) {
        $day_of_week = $_POST['day_of_week'];
        $message_content = addslashes($_POST['message_content']);
        dbquery("UPDATE ".DB_WEEKLY_MESSAGES." SET message_content='$message_content' WHERE day_of_week='$day_of_week'");
        addNotice('success', $locale['sawe_admin_success']);
        redirect(FUSION_SELF . fusion_get_aidlink());
    }
}

// Pobieranie dostępnych dni tygodnia do edycji
$days_of_week = range(11, 34);
$selected_day = isset($_POST['day_of_week']) ? $_POST['day_of_week'] : '11';
$message_content = '';

// Pobieranie treści wiadomości dla wybranego dnia tygodnia
$result = dbquery("SELECT message_content FROM ".DB_WEEKLY_MESSAGES." WHERE day_of_week = '$selected_day'");
$data = dbarray($result);
$message_content = isset($data['message_content']) ? stripslashes($data['message_content']) : ''; // Upewnij się, że zmienna jest ustawiona

echo '<div class="clearfix m-b-10">';
echo '<div class="clearfix m-b-10">';
echo "<div style='text-align:center'><h3><strong>".$locale['menu_title']."</strong></h3></div><br>\n";
echo "<div class='row'>\n";
echo "<div class='col-md-12'>\n";
echo "<div align='center'><ul class='list-inline'>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/admin.php".$aidlink."'><strong>".$locale['menu_admin']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/poniedzialek.php".$aidlink."'><strong>".$locale['day_monday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/wtorek.php".$aidlink."'><strong>".$locale['day_tuesday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/sroda.php".$aidlink."'><strong>".$locale['day_wednesday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/czwartek.php".$aidlink."'><strong>".$locale['day_thursday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/piatek.php".$aidlink."'><strong>".$locale['day_friday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/sobota.php".$aidlink."'><strong>".$locale['day_saturday']."</strong></a></li>\n";
echo "<li><a class='btn btn-primary btn-md' href='".INFUSIONS."weekly_panel/admin/niedziela.php".$aidlink."'><strong>".$locale['day_sunday']."</strong></a></li>\n";
echo "<li><a class='btn btn-success btn-md' href='".INFUSIONS."weekly_panel/admin/niezalogowany.php".$aidlink."'><strong>".$locale['Log_nie']."</strong></a></li>\n";
echo "<li><a class='btn btn-success btn-md' href='".INFUSIONS."weekly_panel/admin/zalogowany.php".$aidlink."'><strong>".$locale['Log_tak']."</strong></a></li>\n"; 
echo "<li><a class='btn btn-success btn-md' href='".INFUSIONS."weekly_panel/admin/godziny.php".$aidlink."'><strong>".$locale['Log_hurs']."</strong></a></li>\n";
echo "</ul></div></div></div><br>\n";
echo "<div align='center'><h3><strong>".$locale['edit_hour']."</strong></h3></div>\n";
echo "<div align='center'><h3><strong>".$locale['edit_message']."</strong></h3></div>\n";
echo openform('weekly_settings', 'post', FUSION_REQUEST);

// Lista rozwijana do wyboru dnia tygodnia
echo '<label for="day_of_week">'.$locale['select_day_of_week'].'</label>';
echo '<select name="day_of_week" id="day_of_week" onchange="this.form.submit()">';
foreach ($days_of_week as $day) {
    // Generowanie napisu dla godziny
    $hour = $day - 10; // Przesunięcie, aby godziny zaczynały się od 1
    $label = ($hour <= 24) ? "Edit Hour $hour" : "Edit Hour " . ($hour - 24); // Dla dni 11-34
    $selected = ($day == $selected_day) ? 'selected' : '';
    echo "<option value='$day' $selected>$label</option>";
}
echo '</select>';

// Pole tekstowe do edycji treści wiadomości
echo '<textarea name="message_content" class="tiny-editor">'.htmlspecialchars($message_content).'</textarea>'; 
echo "<div class='text-center'>
<button type='submit' name='save' class='btn btn-primary btn-md'>".$locale['sawe_admin']."</button>
</div>";
echo closeform();
echo '</div>';

add_to_footer("<script>    
    tinymce.init({
        selector: 'textarea.tiny-editor', 
        plugins: 'lists link image preview code', 
        toolbar: 'undo redo | styleselect | bold italic | alignleft aligncenter alignright | bullist numlist | link image | code', 
        height: 500, // Wysokość edytora
        valid_elements: '*[*]',
        content_css: 'https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic',

        // Ustawienia dotyczące linków
        relative_urls: false,
        remove_script_host: false,
        convert_urls: false,

        // Obsługa polskich znaków
        entity_encoding: 'raw'
    });
</script>");

require_once THEMES . 'templates/footer.php';
?>
