<?php

defined('IN_FUSION') || exit;
require_once INCLUDES . "infusions_include.php";
include INFUSIONS . "weekly_panel/infusion_db.php";

// Pobierz wiadomości dla dni tygodnia z bazy danych
$messages = [];
$result = dbquery("SELECT day_of_week, message_content FROM " . DB_WEEKLY_MESSAGES . " ORDER BY day_of_week ASC");
if (!$result) {
    die("Błąd zapytania: " . mysqli_error($db)); // Użyj mysqli_error() z odpowiednim połączeniem
}
while ($data = dbarray($result)) {
    $messages[$data['day_of_week']] = $data['message_content'];
}

// Pobierz wiadomości dla godzin z bazy danych
$hourly_messages = [];
$result_hourly = dbquery("SELECT hour, message_content FROM " . DB_HOURLY_MESSAGES . " ORDER BY hour ASC");
if (!$result_hourly) {
    die("Błąd zapytania: " . mysqli_error($db)); // Użyj mysqli_error() z odpowiednim połączeniem
}
while ($data_hourly = dbarray($result_hourly)) {
    $hourly_messages[$data_hourly['hour']] = $data_hourly['message_content'];
}

// Określ dzisiejszy dzień tygodnia
$today = date('N'); // 1 (poniedziałek) do 7 (niedziela)

// Określ aktualną godzinę (0 do 23)
$current_hour = date('G'); // Użyj godziny w formacie 24-godzinnym

// Upewnij się, że aktualna godzina mieści się w dozwolonym zakresie
if ($current_hour < 0 || $current_hour > 23) {
    $current_hour = 0; // Domyślnie ustaw na 0, jeśli poza zakresem
}

// Wyświetl wiadomość dla aktualnego dnia tygodnia
$day_message = isset($messages[$today]) ? $messages[$today] : '';

// Wyświetl wiadomość dla aktualnej godziny
$hour_message = isset($hourly_messages[$current_hour + 11]) ? $hourly_messages[$current_hour + 11] : ''; // Dodaj 11, aby uzyskać odpowiedni indeks

// Wyjście wiadomości
echo $day_message;
echo '<br>';
echo $hour_message;

?>
