<?php

defined('IN_FUSION') || exit;
require_once INCLUDES."infusions_include.php";
include INFUSIONS."weekly_panel/infusion_db.php";

// Fetch messages from the database
$messages = [];
$result = dbquery("SELECT day_of_week, message_content FROM ".DB_WEEKLY_MESSAGES." WHERE day_of_week NOT IN (8, 9, 10) ORDER BY day_of_week ASC");
while ($data = dbarray($result)) {
    if ($data['day_of_week'] <= 7) {
        // Store messages by day of the week
        $messages['days'][$data['day_of_week']] = $data['message_content'];
    } elseif ($data['day_of_week'] >= 11 && $data['day_of_week'] <= 34) {
        // Store messages by hour (assuming ID 11 to 34 represent hours 1 to 24)
        $hour_index = $data['day_of_week'] - 10; // ID 11 corresponds to hour 1, so we subtract 10
        $messages['hours'][$hour_index] = $data['message_content'];
    }
}

// Determine today's day of the week and the current hour
$today_day = date('N'); // 1 (Monday) to 7 (Sunday)
$current_hour = date('G') + 1; // 0 (midnight) to 23, +1 to match your hour mapping

// Display the message for the current day and hour
$day_message = isset($messages['days'][$today_day]) ? $messages['days'][$today_day] : '';
$hour_message = isset($messages['hours'][$current_hour]) ? $messages['hours'][$current_hour] : '';

?>

<?php
// Display messages
echo $day_message;
echo '<br>';
echo $hour_message;
?>
