<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright (C) PHP-Fusion Inc
| https://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Filename: kartka_panel/admin.php
| Author: Adi
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
require_once '../../maincore.php';
require_once THEMES . 'templates/admin_header.php';

pageAccess('KK');
$locale = fusion_get_locale('', KK_LOCALE);
$settings = get_settings('kartka_panel');

add_to_title($locale['kar_title']);

add_breadcrumb(['link' => INFUSIONS . 'kartka_panel/admin.php' . fusion_get_aidlink(), 'title' => $locale['kar_title']]);

if (isset($_POST['save_settings'])) {
	$settings = [
		'color_table' => form_sanitizer($_POST['color_table'], '', 'color_table'),
		'bordercolor_table' => form_sanitizer($_POST['bordercolor_table'], '', 'bordercolor_table'),
		'border_table' => form_sanitizer($_POST['border_table'], '', 'border_table'),
		'color_dzien' => form_sanitizer($_POST['color_dzien'], '', 'color_dzien'),
		'size_dzien' => form_sanitizer($_POST['size_dzien'], '', 'size_dzien'),
		'color_data' => form_sanitizer($_POST['color_data'], '', 'color_data'),
		'size_data' => form_sanitizer($_POST['size_data'], '', 'size_data'),
		'color_dzienr' => form_sanitizer($_POST['color_dzienr'], '', 'color_dzienr'),
		'size_dzienr' => form_sanitizer($_POST['size_dzienr'], '', 'size_dzienr'),
		'color_koniecroku' => form_sanitizer($_POST['color_koniecroku'], '', 'color_koniecroku'),
		'size_koniecroku' => form_sanitizer($_POST['size_koniecroku'], '', 'size_koniecroku'),
		'color_zegar' => form_sanitizer($_POST['color_zegar'], '', 'color_zegar'),
		'size_zegar' => form_sanitizer($_POST['size_zegar'], '', 'size_zegar'),
		'color_imieniny' => form_sanitizer($_POST['color_imieniny'], '', 'color_imieniny'),
		'size_imieniny' => form_sanitizer($_POST['size_imieniny'], '', 'size_imieniny'),
		'color_ws' => form_sanitizer($_POST['color_ws'], '', 'color_ws'),
		'size_ws' => form_sanitizer($_POST['size_ws'], '', 'size_ws'),
		'color_za' => form_sanitizer($_POST['color_za'], '', 'color_za'),
		'size_za' => form_sanitizer($_POST['size_za'], '', 'size_za'),
		'size_iws' => form_sanitizer($_POST['size_iws'], '', 'size_iws'),
		'size_iza' => form_sanitizer($_POST['size_iza'], '', 'size_iza'),
		'size_iznak' => form_sanitizer($_POST['size_iznak'], '', 'size_iznak'),
		'color_znak' => form_sanitizer($_POST['color_znak'], '', 'color_znak'),
		'size_znak' => form_sanitizer($_POST['size_znak'], '', 'size_znak'),
		'color_dznak' => form_sanitizer($_POST['color_dznak'], '', 'color_dznak'),
		'size_dznak' => form_sanitizer($_POST['size_dznak'], '', 'size_dznak'),
		'color_kn' => form_sanitizer($_POST['color_kn'], '', 'color_kn'),
		'size_kn' => form_sanitizer($_POST['size_kn'], '', 'size_kn'),
		'color_kks' => form_sanitizer($_POST['color_kks'], '', 'color_kks'),
		'color_k' => form_sanitizer($_POST['color_k'], '', 'color_k'),
		'color_separator' => form_sanitizer($_POST['color_separator'], '', 'color_separator'),
		'g_separator' => form_sanitizer($_POST['g_separator'], '', 'g_separator'),
		'color_link' => form_sanitizer($_POST['color_link'], '', 'color_link'),
		'naglowek_y_n'        => post('naglowek_y_n') ? 1 : 0
	];

	if (\defender::safe()) {
		foreach ($settings as $settings_name => $settings_value) {
			$db = [
				'settings_name'  => $settings_name,
				'settings_value' => $settings_value,
				'settings_inf'   => 'kartka_panel'
			];

			dbquery_insert(DB_SETTINGS_INF, $db, 'update', ['primary_key' => 'settings_name']);
		}

		addNotice('success', $locale['kar_notice']);
		redirect(FUSION_REQUEST);
	}
}

opentable($locale['kar_title']);
echo openform('kar_settings', 'post', FUSION_REQUEST);
echo "<table>";
//-1
echo "<tr>";
echo "<td>";
echo form_colorpicker('color_dzien', $locale['kar_200'], $settings['color_dzien'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);

echo "</td>";
echo "<td>";
echo form_colorpicker('color_dzienr', $locale['kar_600'], $settings['color_dzienr'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_zegar', $locale['kar_910'], $settings['color_zegar'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-2
echo "<tr>";
echo "<td>";
echo form_text('size_dzien', $locale['kar_300'], $settings['size_dzien'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_dzienr', $locale['kar_700'], $settings['size_dzienr'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_zegar', $locale['kar_920'], $settings['size_zegar'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-3
echo "<tr>";
echo "<td>";
echo form_colorpicker('color_data', $locale['kar_400'], $settings['color_data'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_koniecroku', $locale['kar_800'], $settings['color_koniecroku'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_imieniny', $locale['kar_930'], $settings['color_imieniny'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-4
echo "<tr>";
echo "<td>";
echo form_text('size_data', $locale['kar_500'], $settings['size_data'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_koniecroku', $locale['kar_900'], $settings['size_koniecroku'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_imieniny', $locale['kar_940'], $settings['size_imieniny'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-5
echo "<tr>";
echo "<td>";
echo form_colorpicker('color_ws', $locale['kar_950'], $settings['color_ws'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_za', $locale['kar_970'], $settings['color_za'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_znak', $locale['kar_990'], $settings['color_znak'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-6
echo "<tr>";
echo "<td>";
echo form_text('size_ws', $locale['kar_960'], $settings['size_ws'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_za', $locale['kar_980'], $settings['size_za'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_znak', $locale['kar_1010'], $settings['size_znak'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-7
echo "<tr>";
echo "<td>";
echo form_colorpicker('color_dznak', $locale['kar_1020'], $settings['color_dznak'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_table', $locale['kar_100'], $settings['color_table'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_kn', $locale['kar_1040'], $settings['color_kn'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-8
echo "<tr>";
echo "<td>";
echo form_text('size_dznak', $locale['kar_1030'], $settings['size_dznak'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_kks', $locale['kar_1080'], $settings['color_kks'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_kn', $locale['kar_1050'], $settings['size_kn'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-9
echo "<tr>";
echo "<td>";
echo form_colorpicker('bordercolor_table', $locale['kar_1070'], $settings['bordercolor_table'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_k', $locale['kar_1090'], $settings['color_k'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_separator', $locale['kar_1100'], $settings['color_separator'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-10
echo "<tr>";
echo "<td>";
echo form_text('border_table', $locale['kar_1060'], $settings['border_table'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_colorpicker('color_link', $locale['kar_1120'], $settings['color_link'], [
	'max_length'  => 7,
	'inner_width' => '100px',
	'type'        => 'text',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('g_separator', $locale['kar_1110'], $settings['g_separator'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-11
echo "<tr>";
echo "<td>";
echo form_text('size_iws', $locale['kar_1130'], $settings['size_iws'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_iza', $locale['kar_1140'], $settings['size_iza'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "<td>";
echo form_text('size_iznak', $locale['kar_1150'], $settings['size_iznak'], [
	'max_length'  => 2,
	'inner_width' => '100px',
	'type'        => 'number',
	'inline'      => false
]);
echo "</td>";
echo "</tr>";
//-12
echo "<tr>";
echo "<td>";
echo form_checkbox('naglowek_y_n', $locale['kar_1160'], $settings['naglowek_y_n'], [
	'toggle' => TRUE
]);
echo "</td>";
echo "<td>";

echo "</td>";
echo "<td>";

echo "</td>";
echo "</tr>";
//-koniec
echo "<tr>";
echo "<td colspan='3' width='80%'>";
echo "";
echo "</td>";
echo "</tr>";
echo "</table>";
echo form_button('save_settings', $locale['save'], $locale['save'], ['class' => 'btn-success', 'icon' => 'fa fa-hdd-o']);
echo closeform();
closetable();

require_once THEMES . 'templates/footer.php';