<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright (C) PHP-Fusion Inc
| https://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Filename: infusion.php
| Author: Adi
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
defined('IN_FUSION') || exit;

$locale = fusion_get_locale('', KK_LOCALE);

// Infusion general information
$inf_title          = $locale['kar_title'];
$inf_description = $locale['kar_desc'];
$inf_version      = '1.0';
$inf_email       = '';
$inf_weburl      = 'https://www.php-fusion.pl';
$inf_developer   = 'Adi - PHP Fusion Polska';
$inf_folder      = 'kartka_panel';
$inf_image       = 'kar.svg';

// Insert panel
$inf_insertdbrow[] = DB_PANELS . " (panel_name, panel_filename, panel_content, panel_side, panel_order, panel_type, panel_access, panel_display, panel_status, panel_url_list, panel_restriction, panel_languages) VALUES ('" . $inf_title . "', '" . $inf_folder . "', '', '2', '1', 'file', '0', '1', '1', '', '3', '" . fusion_get_settings('enabled_languages') . "')";

// Insert settings
$settings = [
    'color_table'         => '#ffffff',
    'bordercolor_table'         => '#000000',
    'border_table'         => '4',
    'color_dzien'         => '#000000',
    'size_dzien'         => '18',
    'color_data'         => '#000000',
    'size_data'            => '14',
    'color_dzienr'          => '#000000',
    'size_dzienr'        => '12',
    'color_koniecroku'   => '#000000',
    'size_koniecroku'    => '12',
    'color_zegar'        => '#000000',
    'size_zegar'            => '24',
    'color_imieniny'        => '#000000',
    'size_imieniny'            => '10',
    'color_ws'                => '#000000',
    'size_ws'                => '10',
    'size_iws'                => '10',
    'color_za'                => '#000000',
    'size_za'                => '10',
    'size_iza'                => '10',
    'size_iznak'                => '50',
    'color_znak'           => '#000000',
    'size_znak'             => '16',
    'color_dznak'            => '#000000',
    'size_dznak'            => '16',
    'color_kn'            => '#000000',
    'size_kn'            => '16',
    'color_kks'            => '#000000',
    'color_k'            => '#000000',
    'g_separator'            => '1',
    'color_separator'            => '#000000',
    'color_link'        => '#000000',
    'naglowek_y_n' => '1',
];

foreach ($settings as $name => $value) {
    $inf_insertdbrow[] = DB_SETTINGS_INF . " (settings_name, settings_value, settings_inf) VALUES ('" . $name . "', '" . $value . "', '" . $inf_folder . "')";
}

// Multilanguage links
$enabled_languages = makefilelist(LOCALE, '.|..', TRUE, 'folders');
if (!empty($enabled_languages)) {
    foreach ($enabled_languages as $language) {
        if (file_exists(INFUSIONS . 'kartka_panel/locale/' . $language . '.php')) {
            include INFUSIONS . 'kartka_panel/locale/' . $language . '.php';
        }

        $mlt_adminpanel[$language][] = [
            'rights'   => 'KK',
            'image'    => $inf_image,
            'title'    => $inf_title,
            'panel'    => 'admin.php',
            'page'     => 5,
            'language' => $language
        ];

        // Delete
        $mlt_deldbrow[$language][] = DB_ADMIN . " WHERE admin_rights='KK' AND admin_language='" . $language . "'";
    }
} else {
    $inf_adminpanel[] = [
        'rights'   => 'KK',
        'image'    => $inf_image,
        'title'    => $inf_title,
        'panel'    => 'admin.php',
        'page'     => 5,
        'language' => LANGUAGE
    ];
}

// Uninstallation
$inf_deldbrow[] = DB_ADMIN . " WHERE admin_rights='KK'";
$inf_deldbrow[] = DB_PANELS . " WHERE panel_filename='" . $inf_folder . "'";
$inf_deldbrow[] = DB_SETTINGS_INF . " WHERE settings_inf='" . $inf_folder . "'";